/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class VWConfiguration {
    private static final String SEP = "/";
    private PropertyResourceBundle properties = null;
    private String basename = null;

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2005 08:54:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dmcphee  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWConfiguration(String basename) {
        this.basename = basename;
        FileInputStream in = null;
        try {
            in = this.openPropertiesFile(basename + ".properties");
            this.properties = new PropertyResourceBundle(in);
        }
        catch (Exception e) {
            this.properties = (PropertyResourceBundle)ResourceBundle.getBundle(basename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private FileInputStream openPropertiesFile(String basename) throws Exception {
        String fnProp = System.getProperty("filenet.eprocessconfig");
        if (fnProp != null && fnProp.length() > 0) {
            File fnPath = new File(fnProp);
            try {
                return new FileInputStream(fnPath);
            }
            catch (IOException e) {
                throw new VWException("filenet.vw.base.vwconfigration.openprb1", "Cannot locate or cannot read configuration file {0}.", basename);
            }
        }
        File curdir = new File(System.getProperty("user.dir"), basename);
        File homedir = new File(System.getProperty("user.home"), basename);
        File javadir = new File(System.getProperty("java.home"), basename);
        try {
            if (curdir.canRead()) {
                return new FileInputStream(curdir);
            }
            if (homedir.canRead()) {
                return new FileInputStream(homedir);
            }
            if (javadir.canRead()) {
                return new FileInputStream(javadir);
            }
            throw new VWException("filenet.vw.base.vwconfigration.openprb1", "Cannot locate or cannot read configuration file {0}.", basename);
        }
        catch (IOException e) {
            throw new VWException("filenet.vw.base.vwconfigration.openprb1", "Cannot locate or cannot read configuration file {0}.", basename);
        }
    }

    public String getItemValue(String item, String appId) throws VWException {
        String value;
        String pName = item;
        if (appId != null && appId.length() > 0) {
            pName = pName + SEP + appId;
        }
        try {
            value = this.properties.getString(pName);
        }
        catch (MissingResourceException m1) {
            try {
                value = this.properties.getString(item);
            }
            catch (MissingResourceException m2) {
                throw new VWException("filenet.vw.base.vwconfigration.getItemValue", "No value was found for item {0} in configuration file {1}.", item, this.basename);
            }
        }
        return value;
    }
}

